<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

$servername = "localhost";
$username = "iserveco_saidu33";
$password = "08165651922saidu";
$dbname = "iserveco_agro";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Session check
if (!isset($_SESSION['user'])) {
    ?>
    <script>
        alert('Session denied. Please log in.');
        window.open('login.php', '_self');
    </script>
    <?php
    exit();
}

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['submit'])) {
    $id = $_POST['id'];
    $name = $_POST['name'];
    $weight = $_POST['weight'];
    $purity = $_POST['purity'];
    $moisture = $_POST['moisture'];
    $inspection_date = $_POST['inspection_date'];
    $location = $_POST['location'];
    $price = $_POST['price'];
    $availability = $_POST['availability'];
    $productimage = $_FILES["productimage"];

    // Directory for storing images
    $target_dir = "Image/";
    if (!is_dir($target_dir)) {
        mkdir($target_dir);
    }

    // File upload handling
    if (!empty($productimage['name'])) {
        $originalFileName = basename($productimage['name']);
        $imageFileType = strtolower(pathinfo($originalFileName, PATHINFO_EXTENSION));

        // Check if the file type is JPEG
        if ($imageFileType != "jpg") {
            echo "Sorry, only jpg files are allowed.";
            exit();
        }

        // New file name based on product name
        $target_file = $target_dir . $name . '.' . $imageFileType;

        // Check if file already exists and delete it
        if (file_exists($target_file)) {
            unlink($target_file); // Delete the existing file
        }

        // Upload file
        if (!move_uploaded_file($productimage["tmp_name"], $target_file)) {
            echo "Sorry, there was an error uploading your file.";
            exit();
        }
    }

    // Update SQL query
    $sql = "UPDATE products SET 
                weight = ?,
                purity = ?,
                moisture = ?,
                inspection_date = ?,
                location = ?,
                price = ?,
                availability = ?,
                productimage = ?
            WHERE name = ?";

    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        echo "Prepare failed: " . $conn->error;
    } else {
        $stmt->bind_param("dddsdssss", $weight, $purity, $moisture, $inspection_date, $location, $price, $availability, $target_file, $name);

        if ($stmt->execute()) {
            $_SESSION['msg'] = "Product successfully updated!";
            $recordUpdated = true;
        } else {
            echo "Error updating product: " . $stmt->error;
        }

        $stmt->close();
    }
}

// Include header or necessary files
include 'header.php';
?>

<?php if (isset($_SESSION['msg']) && $recordUpdated): ?>
    <!-- Modal for Record Updated -->
    <div id="recordUpdatedModal" class="modal fade">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Record Updated</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <p><?php echo $_SESSION['msg']; ?></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!-- End Modal for Record Updated -->

    <!-- JavaScript to show the modal on page load -->
    <script>
        $(document).ready(function(){
            $("#recordUpdatedModal").modal('show');
        });
    </script>
<?php unset($_SESSION['msg']); ?>
<?php endif; ?>

<div class="container-fluid mt-5">
    <div class="row justify-content-center">
        <div class="col-sm-10">
            <div class="card shadow-lg">
                <div class="card-header bg-primary">
                    <h5 class="text-white">Update Product</h5>
                </div>
                <div class="card-body font-weight-bold">
                    <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post" enctype="multipart/form-data">
                        <input type="hidden" name="id" value="<?php echo isset($_GET['id']) ? $_GET['id'] : ''; ?>">
                        
                        <div class="form-group">
                            <label for="name">Product Name:</label>
                            <select name="name" class="form-control">
                                <option value="">Select Product Name</option>
                                <?php
                                $query = "SELECT name FROM products";
                                $result = $conn->query($query);
                                if ($result->num_rows > 0) {
                                    while ($row = $result->fetch_assoc()) {
                                        $selected = (isset($_POST['name']) && $_POST['name'] == $row['name']) ? 'selected' : '';
                                        echo '<option value="' . $row['name'] . '" ' . $selected . '>' . $row['name'] . '</option>';
                                    }
                                }
                                ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="weight">Weight (kg):</label>
                            <input type="number" step="0.01" name="weight" class="form-control" placeholder="Enter the Weight">
                        </div>

                        <div class="form-group">
                            <label for="purity">Purity (%):</label>
                            <input type="number" step="0.01" name="purity" class="form-control" placeholder="Enter the Purity">
                        </div>

                        <div class="form-group">
                            <label for="moisture">Moisture (%):</label>
                            <input type="number" step="0.01" name="moisture" class="form-control" placeholder="Enter the Moisture">
                        </div>

                    <div class="form-group">
    <label for="inspection_date">Inspection Date:</label>
    <input type="date" id="inspection_date" name="inspection_date" class="form-control" placeholder="Enter the Inspection Date">
</div>

                        <div class="form-group">
                            <label for="location">Location:</label>
                            <input type="text" name="location" class="form-control" placeholder="Enter the Location">
                        </div>

                        <div class="form-group">
                            <label for="price">Price (₦):</label>
                            <input type="number" step="0.01" name="price" class="form-control" placeholder="Enter the Price">
                        </div>

                        <div class="form-group">
                            <label for="availability">Availability:</label>
                            <select name="availability" class="form-control">
                                <option value="Available">Available</option>
                                <option value="Sold Out">Sold Out</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="productimage">Product Image:</label>
                            <input type="file" name="productimage" class="form-control">
                        </div>

                        <div class="form-group">
                            <button type="submit" name="submit" class="btn btn-block btn-info btn-sm font-weight-bold">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript" src="assets/js/jquery/jquery.min.js"></script>
<script type="text/javascript" src="assets/js/jquery-ui/jquery-ui.min.js"></script>
<script type="text/javascript" src="assets/js/popper.js/popper.min.js"></script>
<script type="text/javascript" src="assets/js/bootstrap/js/bootstrap.min.js"></script>
<script type="text/javascript" src="assets/js/jquery-slimscroll/jquery.slimscroll.js"></script>
<script type="text/javascript" src="assets/js/modernizr/modernizr.js"></script>
<script type="text/javascript" src="assets/pages/todo/todo.js"></script>
<script type="text/javascript" src="assets/pages/dashboard/custom-dashboard.min.js"></script>
<script type="text/javascript" src="assets/js/script.js"></script>
<script type="text/javascript" src="assets/js/SmoothScroll.js"></script>
<script src="assets/js/pcoded.min.js"></script>
<script src="assets/js/vartical-demo.js"></script>
<script src="assets/js/jquery.mCustomScrollbar.concat.min.js"></script>
</body>
</html>
