<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Database credentials
$servername = "localhost";
$username = "iserveap_api33";
$password = "iy@uktN2Tgmr";
$dbname = "iserveap_api";
$store_id = 22;

// Paystack API Key
$paystack_secret_key = 'sk_live_135d5e07aa667b01cfe5c9e98ce8ee5c134de779';

// Function to create recipient and return recipient code
function createRecipient($name, $account_number, $bank_code, $paystack_secret_key) {
    // Prepare data for API request to create recipient
    $recipient_data = [
        "type" => "nuban",
        "name" => $name,
        "account_number" => $account_number,
        "bank_code" => $bank_code,
        "currency" => "NGN"
    ];

    $recipient_data_string = json_encode($recipient_data);

    // Make API request to Paystack to create recipient
    $create_recipient_url = "https://api.paystack.co/transferrecipient";
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $create_recipient_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $recipient_data_string);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $paystack_secret_key",
        "Content-Type: application/json",
        "Cache-Control: no-cache"
    ]);

    $recipient_result = curl_exec($ch);
    $recipient_response = json_decode($recipient_result, true);

    curl_close($ch);

    // Check if recipient creation was successful
    if (isset($recipient_response['status']) && $recipient_response['status']) {
        return $recipient_response['data']['recipient_code']; // Return recipient code
    } else {
        return null; // Return null if recipient creation failed
    }
}

// Handle withdrawal request
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['withdraw'])) {
    $name = $_POST['name'];
    $account_number = $_POST['accountNumber'];
    $bank_code = $_POST['bankName'];
    $amount = str_replace(',', '', $_POST['totalAmount']); // Remove commas for API request

    // Create recipient and get recipient code
    $recipient_code = createRecipient($name, $account_number, $bank_code, $paystack_secret_key);

    if ($recipient_code) {
        // Prepare data for API request to initiate transfer
        $transfer_data = [
            "source" => "balance",
            "reason" => "Your reason for transfer",  // Replace with your specific reason
            "amount" => intval($amount * 100),  // Convert amount to kobo (Paystack's requirement)
            "recipient" => $recipient_code  // Use the actual recipient code obtained
        ];

        $transfer_data_string = json_encode($transfer_data);

        // Make API request to Paystack to initiate transfer
        $transfer_url = "https://api.paystack.co/transfer";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $transfer_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $transfer_data_string);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Authorization: Bearer $paystack_secret_key",
            "Content-Type: application/json",
            "Cache-Control: no-cache"
        ]);

        $transfer_result = curl_exec($ch);
        $transfer_response = json_decode($transfer_result, true);

        if (curl_errno($ch)) {
            echo '<div class="alert alert-danger">Curl error: ' . curl_error($ch) . '</div>';
        } else {
            if (isset($transfer_response['status']) && $transfer_response['status']) {
                echo '<div class="alert alert-success">Transfer initiated successfully kindly wait we are proceesing payment to your account.</div>';
            } else {
                echo '<div class="alert alert-danger">Transfer initiation failed: ' . $transfer_response['message'] . '</div>';
            }
        }

        curl_close($ch);
    } else {
        echo '<div class="alert alert-danger">Recipient creation failed.</div>';
    }
}

// Fetch orders for display and calculate total grand amount
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$sql = "SELECT store_id, pickup_date, pickup_slot, delivery_date, delivery_slot, distance_cost, serviceTax, grand_total 
        FROM orders 
        WHERE store_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $store_id);
$stmt->execute();
$result = $stmt->get_result();

$orders = [];
$total_grand_amount = 0;
while ($row = $result->fetch_assoc()) {
    $orders[] = $row;
    $total_grand_amount += $row['grand_total'];
}
$stmt->close();
$conn->close();

// Bank options
$banks = [
    "Access Bank" => "044",
    "Citibank Nigeria" => "023",
    "Ecobank Nigeria" => "050",
    "Fidelity Bank" => "070",
    "First Bank of Nigeria" => "011",
    "First City Monument Bank" => "214",
    "Globus Bank" => "00103",
    "Guaranty Trust Bank" => "058",
    "Heritage Bank" => "030",
    "Jaiz Bank" => "301",
    "Keystone Bank" => "082",
    "Polaris Bank" => "076",
    "PremiumTrust Bank" => "105",
    "Providus Bank" => "101",
    "Stanbic IBTC Bank" => "221",
    "Standard Chartered Bank" => "068",
    "Sterling Bank" => "232",
    "Suntrust Bank" => "100",
    "Titan Bank" => "102",
    "Union Bank of Nigeria" => "032",
    "United Bank For Africa" => "033",
    "Unity Bank" => "215",
    "Wema Bank" => "035",
    "Zenith Bank" => "057"
];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Withdrawal Dashboard</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .container {
            margin-top: 50px;
        }
        .card-header {
            background-color: #007bff;
            color: white;
        }
        .btn-primary {
            background-color: #007bff;
            border-color: #007bff;
        }
    </style>
</head>
<body>
<div class="container">
    <div class="card">
        <div class="card-header">
            <h3>Orders for Store ID: <?php echo $store_id; ?></h3>
        </div>
        <div class="card-body">
            <?php if (!empty($orders)): ?>
                <form method="POST" id="withdrawForm">
                    <table class="table table-bordered">
                        <thead>
                        <tr>
                            <th>Store ID</th>
                            <th>Pickup Date</th>
                            <th>Pickup Slot</th>
                            <th>Delivery Date</th>
                            <th>Delivery Slot</th>
                            <th>Distance Cost</th>
                            <th>Service Tax</th>
                            <th>Grand Total</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($orders as $order): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($order['store_id']); ?></td>
                                <td><?php echo htmlspecialchars($order['pickup_date']); ?></td>
                                <td><?php echo htmlspecialchars($order['pickup_slot']); ?></td>
                                <td><?php echo htmlspecialchars($order['delivery_date']); ?></td>
                                <td><?php echo htmlspecialchars($order['delivery_slot']); ?></td>
                                <td><?php echo htmlspecialchars($order['distance_cost']); ?></td>
                                <td><?php echo htmlspecialchars($order['serviceTax']); ?></td>
                                <td><?php echo htmlspecialchars($order['grand_total']); ?></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                    <hr>
                    <h4>Withdrawal Details</h4>
                    <div class="form-group">
                        <label for="name">Name:</label>
                        <input type="text" class="form-control" id="name" name="name" required>
                    </div>
                    <div class="form-group">
                        <label for="accountNumber">Account Number:</label>
                        <input type="text" class="form-control" id="accountNumber" name="accountNumber" required>
                    </div>
                    <div class="form-group">
                        <label for="bankName">Bank Name:</label>
                        <select class="form-control" id="bankName" name="bankName" required>
                            <option value="">Select Bank</option>
                            <?php foreach ($banks as $bank => $code): ?>
                                <option value="<?php echo htmlspecialchars($code); ?>"><?php echo htmlspecialchars($bank); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="totalAmount">Total Amount:</label>
                        <input type="text" class="form-control" id="totalAmount" name="totalAmount" value="<?php echo htmlspecialchars(number_format($total_grand_amount, 2)); ?>" readonly>
                    </div>
                    <button type="submit" name="withdraw" class="btn btn-primary btn-block">Initiate Withdrawal</button>
                </form>
            <?php else: ?>
                <div class="alert alert-warning">No orders found for store ID <?php echo $store_id; ?>.</div>
            <?php endif; ?>
        </div>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>
</body>
</html>
