<?php

// Retrieve the request's body
$body = @file_get_contents('php://input');

// Verify the request is a valid Paystack webhook event
$paystack_secret_key = 'sk_live_135d5e07aa667b01cfe5c9e98ce8ee5c134de779'; // Replace with your secret key
$paystack_signature = isset($_SERVER['HTTP_X_PAYSTACK_SIGNATURE']) ? $_SERVER['HTTP_X_PAYSTACK_SIGNATURE'] : '';

$signed_payload = $paystack_signature . $body;
$expected_signature = hash_hmac('sha256', $signed_payload, $paystack_secret_key);

if ($paystack_signature != $expected_signature) {
    // Invalid signature
    header('HTTP/1.1 401 Unauthorized');
    exit();
}

// Handle the event
$event = json_decode($body, true);

// Check if the event is a successful payment
if ($event['event'] == 'charge.success') {
    // Payment successful, update your database or perform other actions
    // For example, you can check $event['data']['metadata']['type'] to determine if it's a driver registration payment
    // and then process the registration accordingly
    // $event['data']['metadata']['type'] should correspond to the 'type' in your form data
    $type = $event['data']['metadata']['type'];
    if ($type == 'driver') {
        // Handle driver registration
        // Perform necessary actions, such as storing data in the database
        // Example: Save data to a file
        $file = fopen('driver_registrations.txt', 'a');
        fwrite($file, json_encode($event['data']['metadata']) . "\n");
        fclose($file);

        // Post form details to the API
        $api_url = 'https://iserveapi.com.ng/driverapi.php';
        $form_data = json_encode($event['data']['metadata']);

        $ch = curl_init($api_url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $form_data);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $api_response = curl_exec($ch);
        curl_close($ch);

        // You can handle the API response as needed
        // For example, log the response or perform additional actions
        file_put_contents('api_response.log', $api_response . "\n", FILE_APPEND);
    }
} else {
    // Handle other Paystack events if needed
}

// Respond with a 200 status to acknowledge receipt of the webhook
header('HTTP/1.1 200 OK');

if ($event['event'] == 'charge.success') {
    // Payment successful, update your database or perform other actions
    // For example, you can check $event['data']['metadata']['type'] to determine if it's a driver registration payment
    // and then process the registration accordingly
    // $event['data']['metadata']['type'] should correspond to the 'type' in your form data
    $type = $event['data']['metadata']['type'];
    if ($type == 'freelancer') {
        // Handle driver registration
        // Perform necessary actions, such as storing data in the database
        // Example: Save data to a file
        $file = fopen('vendor_registrations.txt', 'a');
        fwrite($file, json_encode($event['data']['metadata']) . "\n");
        fclose($file);

        // Post form details to the API
        $api_url = 'https://iserveapi.com.ng/vendorapi.php';
        $form_data = json_encode($event['data']['metadata']);

        $ch = curl_init($api_url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $form_data);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $api_response = curl_exec($ch);
        curl_close($ch);

        // You can handle the API response as needed
        // For example, log the response or perform additional actions
        file_put_contents('api_response.log', $api_response . "\n", FILE_APPEND);
    }
} else {
    // Handle other Paystack events if needed
}

// Respond with a 200 status to acknowledge receipt of the webhook
header('HTTP/1.1 200 OK');
