<?php
// Database connection information
$servername = "localhost";
$username = "iserveap_api33";
$password = "iy@uktN2Tgmr";
$dbname = "iserveap_api";

// Allow requests from any origin (for testing purposes)
header("Access-Control-Allow-Origin: *");
// Allow the POST method
header("Access-Control-Allow-Methods: POST");
// Allow specified headers
header("Access-Control-Allow-Headers: Content-Type");

// Create a new MySQLi connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check the connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Parse the JSON data from the POST request
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Validate required fields
if (empty($data['email']) || empty($data['mobile'])) {
    http_response_code(400); // Bad request
    die("Error: Email and mobile number are required.");
}

// Sanitize and prepare data for the user registration query
$first_name = $conn->real_escape_string($data['first_name']);
$last_name = $conn->real_escape_string($data['last_name']);
$email = $conn->real_escape_string($data['email']);
$password = $conn->real_escape_string($data['password']);
$country_code = $conn->real_escape_string($data['country_code']);
$mobile = $conn->real_escape_string($data['mobile']);
$gender = $conn->real_escape_string($data['gender']);
$type = $conn->real_escape_string($data['type']);
$name = $conn->real_escape_string($data['name']);
$zipcode = $conn->real_escape_string($data['zipcode']);
$address = $conn->real_escape_string($data['address']);
$lat = $conn->real_escape_string($data['lat']);
$lng = $conn->real_escape_string($data['lng']);

// Hash the password
$hashed_password = password_hash($password, PASSWORD_BCRYPT);

// Start a transaction
$conn->begin_transaction();

try {
    // Check if mobile number already exists
    $check_mobile_query = $conn->prepare("SELECT COUNT(*) FROM `users` WHERE `mobile` = ?");
    $check_mobile_query->bind_param('s', $mobile);
    $check_mobile_query->execute();
    $check_mobile_result = $check_mobile_query->get_result();
    $existing_mobile_count = $check_mobile_result->fetch_assoc()['COUNT(*)'];

    if ($existing_mobile_count > 0) {
        // Mobile number already exists, handle error
        http_response_code(409); // Conflict
        throw new Exception("Error: Mobile number already exists for another store.");
    }


    // Prepare the SQL query for inserting the new user record
    $insert_user_query = $conn->prepare("INSERT INTO `users` (`first_name`, `last_name`, `email`, `password`, `country_code`, `mobile`, `gender`, `type`, `status`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, 0)");
    $insert_user_query->bind_param('ssssssss', $first_name, $last_name, $email, $hashed_password, $country_code, $mobile, $gender, $type);

    // Execute the prepared user registration query
    if ($insert_user_query->execute() === false) {
        throw new Exception('User registration failed: ' . $conn->error);
    }

    // Get the last inserted user ID
    $user_id = $conn->insert_id;

    // Prepare the SQL query for inserting the new store record
    $insert_store_query = $conn->prepare("INSERT INTO `stores` (`uid`, `name`, `zipcode`, `address`, `lat`, `lng`, `status`) VALUES (?, ?, ?, ?, ?, ?, 0)");
    $insert_store_query->bind_param('isssdd', $user_id, $name, $zipcode, $address, $lat, $lng);

    // Execute the prepared store information query
    if ($insert_store_query->execute() === false) {
        throw new Exception('Store information insertion failed: ' . $conn->error);
    }

    // Commit the transaction
    $conn->commit();

    // Both user registration and store information added successfully
    echo 'Form Payment successful.. Kindly Login on Iserve Vendor App';
} catch (Exception $e) {
    // An error occurred, rollback the transaction
    $conn->rollback();

    // Output the error message
    echo 'Error: ' . $e->getMessage();
}

// Close the prepared statements
if (isset($check_mobile_query)) {
    $check_mobile_query->close();
}
if (isset($check_email_query)) {
    $check_email_query->close();
}
if (isset($insert_user_query)) {
    $insert_user_query->close();
}
if (isset($insert_store_query)) {
    $insert_store_query->close();
}

// Close the database connection
$conn->close();
?>
